/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.comp.PopupWindow;
import DE.siemens.ad.logo.dialog.CompactBlockSelectionPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.ConnectConnectorWithAction;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectOutConnectorWithAction
extends ConnectConnectorWithAction {
    public ConnectOutConnectorWithAction() {
        this.putValue("Name", "edit.connectOutConnectorWith");
        this.putValue("textKey", "edit.connectOutConnectorWith");
        this.disabledContextVector = new Vector(2);
        this.disabledContextVector.add(SimulationTool.class);
        this.disabledContextVector.add(OnlineTestTool.class);
    }

    public boolean doIt() {
        this.fLogoDrawing = (LogoDrawing)this.getDrawingView().drawing();
        Vector selection = this.getDrawingView().selection();
        if (selection.isEmpty() || selection.size() > 1 || !(selection.elementAt(0) instanceof OutputIfcFigure)) {
            return false;
        }
        this.fOutputFigure = (OutputIfcFigure)selection.elementAt(0);
        OutBlockConnector outBlockConnector = (OutBlockConnector)this.fOutputFigure.getBlockConnector();
        if (!outBlockConnector.isConnectable()) {
            return false;
        }
        WiringDiagram wiringDiagram = this.fLogoDrawing.getWiringDiagram();
        Vector blocks = wiringDiagram.getBlocks();
        Vector<Block> connectableBlocks = new Vector<Block>();
        Enumeration e = blocks.elements();
        Block block = null;
        block0: while (e.hasMoreElements()) {
            block = (Block)e.nextElement();
            if (outBlockConnector.getOwner() == block || outBlockConnector.getOwner() instanceof DeputyBlock && ((DeputyBlock)outBlockConnector.getOwner()).getParent() == block) continue;
            for (int i = 0; i < block.getInConnectorCount(); ++i) {
                InBlockConnector inBlockConnector = block.getInConnector(i);
                if (!this.connectorTypesCompatible(outBlockConnector, inBlockConnector) || !wiringDiagram.canConnectWithoutRecursion(outBlockConnector, inBlockConnector) || !inBlockConnector.isConnectable()) continue;
                connectableBlocks.add(block);
                continue block0;
            }
        }
        this.fCompactBlockSelectionPanel = new CompactBlockSelectionPanel(connectableBlocks, this.fLogoDrawing);
        this.fCompactBlockSelectionPanel.setRemidInfo(Language.getString("dialog.selectInConnector.remindInfo", "Select an in connector to connect"));
        this.fCompactBlockSelectionPanel.setConnectorsVisible(true);
        this.fCompactBlockSelectionPanel.setConnectorVerifier(new ConnectionConnectorVerifier());
        ConnectConnectorWithAction.DoubleClickHandler doubleClickHandler = new ConnectConnectorWithAction.DoubleClickHandler();
        this.fCompactBlockSelectionPanel.getBlockList().addMouseListener(doubleClickHandler);
        this.fCompactBlockSelectionPanel.getConnectorList().addMouseListener(doubleClickHandler);
        this.fPopupWindow = new PopupWindow(this.getOwner().getWindow());
        this.fPopupWindow.addPopupWindowListener(this);
        Point popupPosition = this.fOutputFigure.displayBox().getLocation();
        popupPosition.translate(-35, 10);
        popupPosition = this.getDrawingView().getZoomManager().convertModelToDisplayCoordinates(popupPosition);
        popupPosition.translate(-200, 10);
        this.fPopupWindow.getContentPane().add(this.fCompactBlockSelectionPanel);
        this.fPopupWindow.show(this.getDrawingView(), new Rectangle(popupPosition, new Dimension(200, 200)));
        return true;
    }

    public void popupWindowApproved(PopupWindow.PopupWindowEvent popupEvent) {
        Block selectedBlock = this.fCompactBlockSelectionPanel.getSelectedBlock();
        if (selectedBlock == null) {
            return;
        }
        BlockConnector blockConnector = this.fCompactBlockSelectionPanel.getSelectedConnector();
        if (!(blockConnector instanceof InBlockConnector)) {
            return;
        }
        BlockFigure successorBlock = this.fLogoDrawing.getBlockFigure(selectedBlock);
        this.fInputFigure = successorBlock.getInputIfcFigure(blockConnector);
        this.createAndInsertConnection(this.fOutputFigure, this.fInputFigure);
    }

    protected class ConnectionConnectorVerifier
    implements CompactBlockSelectionPanel.ConnectorVerifier {
        protected ConnectionConnectorVerifier() {
        }

        public boolean isConnectorValid(BlockConnector blockConnector) {
            return blockConnector.isConnectable();
        }
    }
}

